!STB 0 F
    Package    6  String   PalmDatabaseInterfacer      PalmDatabaseInterface.pacr        STBCollectionProxy    N
    STBClassProxy    r      Dolphinr      IdentitySet&  Array    STBSymbolProxy    r      PDB:      r      PilotRecord                 r      Set      Association    :      r   	   ByteArray:      r      dwordAtOffset:put:bigEndian:      r   
   Time class:      r      dateAndTimeFromSeconds:        :      r      wordAtOffset:bigEndian:        :      r      dwordAtOffset:bigEndian:        :      r      wordAtOffset:put:bigEndian:                                      STBIdentityDictionaryProxy              r      IdentityDictionary     :      r      postinstall   :      r   
   postuninstall   :      r   
   preinstall   :      r      preuninstall                                Object subclass: #PDB
	instanceVariableNames: 'header filler appInfo entries exportUniqueIDs'
	classVariableNames: ''
	poolDictionaries: ''!

Object subclass: #PilotRecord
	instanceVariableNames: 'chunk attrs uniqueID id type'
	classVariableNames: ''
	poolDictionaries: ''!

'end-class-definition'! X    

PDB class instanceVariableNames: ''!

PDB comment: 'A PDB is the in-memory representation of a PalmOS(R) PDB or PRC database.

It holds a header and a list of entries (the records/resources). Record indices start at 0 (zero).
'!

PDB guid: (GUID fromString: '{97862800-315A-11D4-99FC-00105AF9D0C7}')!

!PDB categoriesForClass!Unclassified! !

!PDB methodsFor!

addRecord: aPilotRecord
	| index |
	index := entries size.
	entries add: aPilotRecord.
	^index!

appInfo
	^appInfo!

appInfo: aByteArray
	appInfo := aByteArray!

appInfoAreaOffset
	^self headerFieldAt: 16r34 long: true!

appInfoAreaOffset: anInteger
	^self headerFieldAt: 16r34 put: anInteger long: true!

attributes
	^self headerFieldAt: 16r20 long: false!

attributes: anInteger
	self headerFieldAt: 16r20 put: anInteger long: false!

clearAttribute: anInteger
	self attributes: (self attributes bitClear: anInteger)!

creationDate
	"Answer the Date and the Time when the receiver was created."

	^self dateAndTimeFromPilotSeconds: (self headerFieldAt: 16r24 long: true)!

creationDate: anArray
	"Set the receiver's creation date to the given Date and Time."

	self headerFieldAt: 16r24
		put: (self pilotSecondsFromDateAndTime: anArray)
		long: true!

creator
	^PDB idStringOf: (self headerFieldAt: 16r40 long: true)!

creator: aString
	self headerFieldAt: 16r40 put: (PDB id: aString) long: true!

dateAndTimeFromPilotSeconds: anInteger
	"Answer an Array of a Date and a Time corresponding to the the Pilot's notion of seconds since January 1, 1904. Note that Squeak's Date and Time class>>fromSeconds: start at 1901."

	^Time fromSeconds: anInteger + self dateOffset!

dateOffset
	"Answer the number of seconds between Jan 1, 1901 and Jan 1, 1904."

	^94608000	"3*365*24*3600"!

export: aFileStream
	"Export the receiver onto the given stream. Does not close the stream!! Cf. #exportToNewFileNamed:"

	| recStart |
	self recordCountField: self recordCount.
	recStart := self headerSize
		+ (self recordCount * (self isPRC ifTrue: [10] ifFalse: [8]))
		+ (self hadFiller ifTrue: [filler size] ifFalse: [0]).
	self appInfo notNil ifTrue:
		[self isPRC ifTrue: [self error: 'PRC files shouldn''t have an appInfo area'].
		self appInfoAreaOffset: recStart.
		recStart := recStart + (self appInfo size alignedTo: 2)].	"see below (odd filler)"
	aFileStream nextPutAll: header.
	self isPRC
		ifTrue: [self exportPRCList: aFileStream chunksFrom: recStart]
		ifFalse: [self exportPDBList: aFileStream chunksFrom: recStart].
	self hadFiller ifTrue: [aFileStream nextPutAll: filler].
	self appInfo notNil ifTrue:
		[aFileStream nextPutAll: self appInfo.
		appInfo size odd ifTrue: [aFileStream nextPut: 0]].	"is this really needed?"
	self exportRecords: aFileStream!

exportedUniqueIDFor: aPilotRecord
	"Exporting of preset uniqueIDs is not recommended. Use zero, the Pilot will generate its own."

	^exportUniqueIDs
		ifTrue: [aPilotRecord uniqueID]
		ifFalse: [0]!

exportPDBList: aFileStream chunksFrom: anInteger

	| listEntry dataOfs |
	dataOfs := anInteger.
	listEntry := ByteArray new: 8.
	self recordsDo:
		[ :record | listEntry
			dwordAtOffset: 0 put: dataOfs bigEndian: true;
			dwordAtOffset: 4 put: (self exportedUniqueIDFor: record) bigEndian: true;
			at: 5 put: (record attributes bitAnd: 16rFF).
		aFileStream nextPutAll: listEntry.
		dataOfs := dataOfs + record data size]!

exportPRCList: aFileStream chunksFrom: anInteger

	| listEntry dataOfs |
	dataOfs := anInteger.
	listEntry := ByteArray new: 10.
	self recordsDo:
		[ :record | listEntry
			dwordAtOffset: 6 put: dataOfs bigEndian: true;
			dwordAtOffset: 0 put: record typeAsLong bigEndian: true;
			wordAtOffset: 4 put: record id bigEndian: true.
		aFileStream nextPutAll: listEntry.
		dataOfs := dataOfs + record data size]!

exportRecords: aFileStream

	self recordsDo:
		[:each | aFileStream nextPutAll: each data]!

exportToNewFileNamed: aString
	"Export the receiver into the file with the given name."

	| fs sub path ext |
	sub := aString reverse subStrings: $..
	ext := ( sub at: 1) reverse.
	path := (sub at: 2) reverse.

	fs := FileStream write: (File path: path extension: ext) text: false.
	[ self export: fs ] ensure: [ fs close ].
!

exportUniqueIDs: aBoolean
	"Guards whether UniqueIDs will be exported as set in the records. Sending true is not recommended by the PDB spec, and false is the default anyway."

	exportUniqueIDs := aBoolean!

hadFiller
	"Answer whether two filler bytes after the record list were present on import."

	^filler notNil!

hasAttribute: anInteger
	^self attributes allMask: anInteger!

headerFieldAt: anInteger long: aBoolean
	^aBoolean
		ifTrue: [header dwordAtOffset: anInteger bigEndian: true]
		ifFalse: [header wordAtOffset: anInteger bigEndian: true]!

headerFieldAt: anInteger put: valueInteger long: aBoolean
	aBoolean
		ifTrue: [header dwordAtOffset: anInteger put: valueInteger bigEndian: true]
		ifFalse: [header wordAtOffset: anInteger put: valueInteger bigEndian: true]!

headerSize
	^16r4E!

import: aFileStream
	"Import the receiver's contents from the given stream. Does not close the stream afterwards!! Cf. #importFromFileNamed:"

	header := aFileStream next: self headerSize.
	self isPRC
		ifTrue: [self importPRCProper: aFileStream]
		ifFalse: [self importPDBProper: aFileStream]!

importAppInfoArea: aFileStream recordList: anArray
	| appInfoStart appInfoEnd |
	(appInfoStart := self appInfoAreaOffset) > 0
		ifTrue:
			[appInfoEnd := anArray isEmpty
				ifTrue: [aFileStream size]
				ifFalse: [(anArray at: 1) at: 1].	"start of first record"
			aFileStream position = appInfoStart
				ifFalse: [filler := aFileStream next: 2].
			self appInfo: (aFileStream next: (appInfoEnd-appInfoStart))]!

importChunk: aByteArray with: anArray resource: aBoolean

	| rec |
	rec := PilotRecord new data: aByteArray.
	aBoolean
		ifTrue: [rec typeFromLong: (anArray at: 2); id: (anArray at: 3)]
		ifFalse: [rec attributes: (anArray at: 2); uniqueID: (anArray at: 3)].
	self addRecord: rec!

importChunks: anArray from: aFileStream resources: aBoolean

	| last entryStart entrySize data |
	last := anArray size.
	anArray do:
		[ :entry | | i |
		i := anArray identityIndexOf: entry.
		entryStart := entry at: 1.
		entrySize := (i == last
			ifFalse: [(anArray at: i+1) at: 1]
			ifTrue: [aFileStream size]) - entryStart.
		aFileStream position: entryStart.
		data := aFileStream next: entrySize.
		self importChunk: data with: entry resource: aBoolean]!

importFromFileNamed: aString
	"Import the receiver from the given filename."

	| fs |
	fs := (FileStream read: aString text: false).
"	self import: fs.
	fs close
"	[self import: fs] ensure: [fs close].
	!

importPDBProper: aFileStream

	| recList entry |
	recList := (Array new: self recordCountField) collect:
		[ :dummy |
		entry := aFileStream next: 8.
		Array
			with: (entry dwordAtOffset: 0 bigEndian: true)
			with: (entry at: 5)
			with: ((entry dwordAtOffset: 4 bigEndian: true) bitAnd: 16rFFFFFF)].
	self importAppInfoArea: aFileStream recordList: recList.
	self importChunks: recList from: aFileStream resources: false!

importPRCProper: aFileStream

	| recList entry |
	recList := (Array new: self recordCountField) collect:
		[ :dummy |
		entry := aFileStream next: 10.
		Array
			with: (entry dwordAtOffset: 6 bigEndian: true)
			with: (entry dwordAtOffset: 0 bigEndian: true)
			with: (entry wordAtOffset: 4 bigEndian: true)].
	self appInfoAreaOffset = 0
		ifFalse: [self error: 'PRC files shouldn''t have an appInfoArea'].
	aFileStream position = recList first first
		ifFalse: [filler := aFileStream next: 2].
	self importChunks: recList from: aFileStream resources: true!

initialize
	header := ByteArray new: self headerSize.
	entries := OrderedCollection new.
	filler := nil.
	exportUniqueIDs := false!

isPDB
	^self isPRC not!

isPRC
	^self hasAttribute: PDB dmHdrAttrResDB!

lastBackupDate
	"Answer the Date and the Time when the receiver was last backed up."

	^self dateAndTimeFromPilotSeconds: (self headerFieldAt: 16r2C long: true)!

lastBackupDate: anArray
	"Set the receiver's last backup date to the given Date and Time."

	self headerFieldAt: 16r2C
		put: (self pilotSecondsFromDateAndTime: anArray)
		long: true!

modificationDate
	"Answer the Date and the Time when the receiver was last modified."

	^self dateAndTimeFromPilotSeconds: (self headerFieldAt: 16r28 long: true)!

modificationDate: anArray
	"Set the receiver's last modification date to the given Date and Time."

	self headerFieldAt: 16r28
		put: (self pilotSecondsFromDateAndTime: anArray)
		long: true!

modificationNumber
	^self headerFieldAt: 16r30 long: true!

modificationNumber: anInteger
	self headerFieldAt: 16r30 put: anInteger long: true!

name
	^self nameField asString!

name: aString

	aString size == 0 ifTrue: [self error: 'must use a non-empty name'].
	self nameField:
		((ByteArray new: 32) replaceFrom: 1 to: (aString size min: 31) with: aString)!

nameField
	"Answer an extracted ByteArray of the header's name field."

	^header copyFrom: 1 to: 32!

nameField: aByteArray
	"Punch the given ByteArray over the header's name field."

	aByteArray size == 32 ifFalse: [self error: 'name field must consist of 32 bytes'].
	header replaceFrom: 1 to: 32 with: aByteArray!

nextRecordListID
	^self headerFieldAt: 16r48 long: true!

pilotSecondsFromDateAndTime: anArray
	"Answer the PalmOS(R) date (seconds since 1904-01-01) from the given Date and Time."

	| secs |
	secs := (anArray at: 1) asSeconds + (anArray at: 2) asSeconds.
	^secs - self dateOffset!

recordAt: anInteger
	^entries at: anInteger+1!

recordAt: anInteger put: aPilotRecord
	^entries at: anInteger+1 put: aPilotRecord!

recordCount
	"Since the receiver is the in-memory representation, answer the count as seen by the entries collection. New PDBs don't have the value in their header yet. But see recordCountField for completeness."

	^entries size!

recordCountField
	^self headerFieldAt: 16r4C long: false!

recordCountField: anInteger
	self headerFieldAt: 16r4C put: anInteger long: false!

recordsDo: aBlock
	"Evaluate the block for every record."

	entries do: aBlock!

setAttribute: anInteger
	self attributes: (self attributes bitOr: anInteger)!

sortInfoAreaOffset
	^self headerFieldAt: 16r38 long: true!

type
	^PDB idStringOf: (self headerFieldAt: 16r3C long: true)!

type: aString
	self headerFieldAt: 16r3C put: (PDB id: aString) long: true!

uniqueIDSeed
	^self headerFieldAt: 16r44 long: true!

version
	^self headerFieldAt: 16r22 long: false!

version: anInteger
	self headerFieldAt: 16r22 put: anInteger long: false! !

!PDB categoriesFor: #addRecord:!*-unclassified!public! !
!PDB categoriesFor: #appInfo!*-unclassified!public! !
!PDB categoriesFor: #appInfo:!*-unclassified!public! !
!PDB categoriesFor: #appInfoAreaOffset!*-unclassified!public! !
!PDB categoriesFor: #appInfoAreaOffset:!*-unclassified!public! !
!PDB categoriesFor: #attributes!*-unclassified!public! !
!PDB categoriesFor: #attributes:!*-unclassified!public! !
!PDB categoriesFor: #clearAttribute:!*-unclassified!public! !
!PDB categoriesFor: #creationDate!*-unclassified!public! !
!PDB categoriesFor: #creationDate:!*-unclassified!public! !
!PDB categoriesFor: #creator!*-unclassified!public! !
!PDB categoriesFor: #creator:!*-unclassified!public! !
!PDB categoriesFor: #dateAndTimeFromPilotSeconds:!*-unclassified!public! !
!PDB categoriesFor: #dateOffset!*-unclassified!public! !
!PDB categoriesFor: #export:!*-unclassified!public! !
!PDB categoriesFor: #exportedUniqueIDFor:!*-unclassified!public! !
!PDB categoriesFor: #exportPDBList:chunksFrom:!*-unclassified!public! !
!PDB categoriesFor: #exportPRCList:chunksFrom:!*-unclassified!public! !
!PDB categoriesFor: #exportRecords:!*-unclassified!public! !
!PDB categoriesFor: #exportToNewFileNamed:!*-unclassified!public! !
!PDB categoriesFor: #exportUniqueIDs:!*-unclassified!public! !
!PDB categoriesFor: #hadFiller!*-unclassified!public! !
!PDB categoriesFor: #hasAttribute:!*-unclassified!public! !
!PDB categoriesFor: #headerFieldAt:long:!*-unclassified!public! !
!PDB categoriesFor: #headerFieldAt:put:long:!*-unclassified!public! !
!PDB categoriesFor: #headerSize!*-unclassified!public! !
!PDB categoriesFor: #import:!*-unclassified!public! !
!PDB categoriesFor: #importAppInfoArea:recordList:!*-unclassified!public! !
!PDB categoriesFor: #importChunk:with:resource:!*-unclassified!public! !
!PDB categoriesFor: #importChunks:from:resources:!*-unclassified!public! !
!PDB categoriesFor: #importFromFileNamed:!*-unclassified!public! !
!PDB categoriesFor: #importPDBProper:!*-unclassified!public! !
!PDB categoriesFor: #importPRCProper:!*-unclassified!public! !
!PDB categoriesFor: #initialize!*-unclassified!public! !
!PDB categoriesFor: #isPDB!*-unclassified!public! !
!PDB categoriesFor: #isPRC!*-unclassified!public! !
!PDB categoriesFor: #lastBackupDate!*-unclassified!public! !
!PDB categoriesFor: #lastBackupDate:!*-unclassified!public! !
!PDB categoriesFor: #modificationDate!*-unclassified!public! !
!PDB categoriesFor: #modificationDate:!*-unclassified!public! !
!PDB categoriesFor: #modificationNumber!*-unclassified!public! !
!PDB categoriesFor: #modificationNumber:!*-unclassified!public! !
!PDB categoriesFor: #name!*-unclassified!public! !
!PDB categoriesFor: #name:!*-unclassified!public! !
!PDB categoriesFor: #nameField!*-unclassified!public! !
!PDB categoriesFor: #nameField:!*-unclassified!public! !
!PDB categoriesFor: #nextRecordListID!*-unclassified!public! !
!PDB categoriesFor: #pilotSecondsFromDateAndTime:!*-unclassified!public! !
!PDB categoriesFor: #recordAt:!*-unclassified!public! !
!PDB categoriesFor: #recordAt:put:!*-unclassified!public! !
!PDB categoriesFor: #recordCount!*-unclassified!public! !
!PDB categoriesFor: #recordCountField!*-unclassified!public! !
!PDB categoriesFor: #recordCountField:!*-unclassified!public! !
!PDB categoriesFor: #recordsDo:!*-unclassified!public! !
!PDB categoriesFor: #setAttribute:!*-unclassified!public! !
!PDB categoriesFor: #sortInfoAreaOffset!*-unclassified!public! !
!PDB categoriesFor: #type!*-unclassified!public! !
!PDB categoriesFor: #type:!*-unclassified!public! !
!PDB categoriesFor: #uniqueIDSeed!*-unclassified!public! !
!PDB categoriesFor: #version!*-unclassified!public! !
!PDB categoriesFor: #version:!*-unclassified!public! !

!PDB class methodsFor!

dmHdrAttrAppInfoDirty
	^4!

dmHdrAttrAttrBackup
	^8!

dmHdrAttrCopyPrevention
	^64!

dmHdrAttrOKToInstallNewer
	^16!

dmHdrAttrOpen
	^16r8000!

dmHdrAttrReadOnly
	^2!

dmHdrAttrResDB
	^1!

dmHdrAttrResetAfterInstall
	^32!

dmHdrAttrStream
	^128!

examples
	"You must supply real PDB and PRC files. Adjust the filenames accordingly."

	"Import the Memo database and examine the records. Provided you use a real MemoDB, you can see the memo's text in the Explorer by selecting a record and printing 'self data asString' in the lower pane. Note that all records end in '0 asCharacter'..."

		(PDB new importFromFileNamed: 'C:\Temp\MemoDB.pdb') inspect.

	"Import a PalmOS(R) application and examine its resources"

		(PDB new importFromFileNamed: 'C:\Temp\Year.prc') explore.

	"Create a very simple PDB. Note the 'false' parameter to resource:..."

		(PDB named: 'My first PDB' type: 'HELL' creator: 'WORL' resource: false)
			addRecord: (PilotRecord new data: 'Hello, world.'; attributes: 0);
			exportToNewFileNamed: 'C:\Temp\MyPDB.pdb'.

	"Reopen it and examine its contents."

		(PDB new importFromFileNamed: 'C:\Temp\MyPDB.pdb') inspect.

	"Create a very simple PRC. Do not sync that one to a real Pilot."

		(PDB named: 'My first PRC' type: 'HELL' creator: 'WORL' resource: true)
			addRecord: (PilotRecord new type: 'NONS'; id: 101; data: 'Hello, world.');
			exportToNewFileNamed: 'C:\Temp\MyPRC.prc'.

	"Reopen it and examine its contents."

		(PDB new importFromFileNamed: 'C:\Temp\MyPRC.prc') inspect.

	"Copy a PDB. Note that uniqueIDs will be cleared on export, as recommended by the PDB spec."

		(PDB new importFromFileNamed: 'C:\Temp\MemoDB.pdb')
			exportToNewFileNamed: 'C:\Temp\CopiedMemoDB.pdb'.

	"Copy a PRC. PRCs don't have uniqueIDs, so the result should be bit-identical."

		(PDB new importFromFileNamed: 'C:\Temp\Year.prc')
			exportToNewFileNamed: 'C:\Temp\CopiedYear.prc'.

	"Copy a PDB verbatim, preserving the uniqueIDs. Included for completeness to show bit-identicalness is possible. Remember that uniqueIDs *should* be cleared on export, as recommended by the PDB spec. Don't confuse your Pilot. <g>"

		(PDB new importFromFileNamed: 'C:\Temp\MemoDB.pdb')
			exportUniqueIDs: true;
			exportToNewFileNamed: 'C:\Temp\VerbatimCopiedMemoDB.pdb'!

id: aString
	"Answer the integer corresponding to the 4-character type/creator literal."
	"(PDB id: 'ABCD') hex"

	aString size = 4 ifFalse: [self error: 'IDs must consist of 4 characters'].
	^aString asByteArray dwordAtOffset: 0 bigEndian: true!

idStringOf: anInteger
	"Answer the String representation of the given 4-byte creator/type id."

	^(ByteArray new: 4)
		dwordAtOffset: 0 put: anInteger bigEndian: true;
		asString!

named: aString type: typeString creator: creatorString resource: aBoolean
	| now |
	now := Time dateAndTimeNow.
	^self new
		name: aString;
		type: typeString;
		creator: creatorString;
		creationDate: now;
		modificationDate: now;
		setAttribute: (aBoolean ifTrue: [PDB dmHdrAttrResDB] ifFalse: [0])!

new
	^super new
		initialize! !

!PDB class categoriesFor: #dmHdrAttrAppInfoDirty!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrAttrBackup!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrCopyPrevention!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrOKToInstallNewer!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrOpen!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrReadOnly!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrResDB!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrResetAfterInstall!*-unclassified!public! !
!PDB class categoriesFor: #dmHdrAttrStream!*-unclassified!public! !
!PDB class categoriesFor: #examples!*-unclassified!public! !
!PDB class categoriesFor: #id:!*-unclassified!public! !
!PDB class categoriesFor: #idStringOf:!*-unclassified!public! !
!PDB class categoriesFor: #named:type:creator:resource:!*-unclassified!public! !
!PDB class categoriesFor: #new!*-unclassified!public! !



PilotRecord class instanceVariableNames: ''!

PilotRecord comment: 'A PilotRecord lives either in a PDB or a PRC. It carries a ByteArray as its data. When it is a PDB record, it has attributes and a UniqueID. As a PRC record, it has a resource name (like ''code'', expressed as an unsigned long) and an ID (SmallInteger).'!

PilotRecord guid: (GUID fromString: '{97862802-315A-11D4-99FC-00105AF9D0C7}')!

!PilotRecord categoriesForClass!PalmOS-Databases! !

!PilotRecord methodsFor!

attributes
	attrs isNil ifTrue: [attrs := 0].
	^attrs!

attributes: aSmallInteger
	attrs := aSmallInteger!

bePublic
	self clearAttribute: PilotRecord dmRecAttrSecret!

beSecret
	self setAttribute: PilotRecord dmRecAttrSecret!

category
	^self attributes bitAnd: PilotRecord dmRecAttrCategoryMask!

category: aSmallInteger
	^self attributes:
		((self attributes bitAnd: PilotRecord dmAllRecAttrs)
			bitOr: (aSmallInteger bitAnd: PilotRecord dmRecAttrCategoryMask))!

clearAttribute: aSmallInteger
	self attributes: 
		(self attributes bitClear: (aSmallInteger bitAnd: PilotRecord dmAllRecAttrs))!

data
	^chunk!

data: aByteArray
	chunk := aByteArray!

hasAttributes: aSmallInteger
	^self attributes allMask: aSmallInteger!

id
	^id!

id: aSmallInteger
	id := aSmallInteger!

isRecord
	^attrs notNil and: [uniqueID notNil]!

isResource
	^type notNil and: [id notNil]!

isSecret
	^self hasAttributes: PilotRecord dmRecAttrSecret!

markForArchival
	"Archive receiving record on next HotSync."

	self setAttribute: PilotRecord dmRecAttrDirty!

markForDeletion
	"Delete receiving record on next HotSync."

	self setAttribute: PilotRecord dmRecAttrDelete!

printOn: aStream

	self isResource
		ifTrue: [aStream nextPutAll: self type printString;
					nextPut: $(;
					nextPutAll: self id printString;
					nextPut: $)]
		ifFalse: [super printOn: aStream]!

setAttribute: aSmallInteger
	self attributes: 
		(self attributes bitOr: (aSmallInteger bitAnd: PilotRecord dmAllRecAttrs))!

type
	^PDB idStringOf: type!

type: aString
	type := PDB id: aString!

typeAsLong
	^type!

typeFromLong: anInteger
	type := anInteger!

uniqueID
	^uniqueID!

uniqueID: anInteger
	"UniqueIDs may be assigned, but will not be exported because that's not recommended by the spec. Unless you change (or subclass) PDB>>exportedUniqueIDFor:"

	uniqueID := anInteger! !

!PilotRecord categoriesFor: #attributes!*-unclassified!public! !
!PilotRecord categoriesFor: #attributes:!*-unclassified!public! !
!PilotRecord categoriesFor: #bePublic!*-unclassified!public! !
!PilotRecord categoriesFor: #beSecret!*-unclassified!public! !
!PilotRecord categoriesFor: #category!*-unclassified!public! !
!PilotRecord categoriesFor: #category:!*-unclassified!public! !
!PilotRecord categoriesFor: #clearAttribute:!*-unclassified!public! !
!PilotRecord categoriesFor: #data!*-unclassified!public! !
!PilotRecord categoriesFor: #data:!*-unclassified!public! !
!PilotRecord categoriesFor: #hasAttributes:!*-unclassified!public! !
!PilotRecord categoriesFor: #id!*-unclassified!public! !
!PilotRecord categoriesFor: #id:!*-unclassified!public! !
!PilotRecord categoriesFor: #isRecord!*-unclassified!public! !
!PilotRecord categoriesFor: #isResource!*-unclassified!public! !
!PilotRecord categoriesFor: #isSecret!*-unclassified!public! !
!PilotRecord categoriesFor: #markForArchival!*-unclassified!public! !
!PilotRecord categoriesFor: #markForDeletion!*-unclassified!public! !
!PilotRecord categoriesFor: #printOn:!*-unclassified!public! !
!PilotRecord categoriesFor: #setAttribute:!*-unclassified!public! !
!PilotRecord categoriesFor: #type!*-unclassified!public! !
!PilotRecord categoriesFor: #type:!*-unclassified!public! !
!PilotRecord categoriesFor: #typeAsLong!*-unclassified!public! !
!PilotRecord categoriesFor: #typeFromLong:!*-unclassified!public! !
!PilotRecord categoriesFor: #uniqueID!*-unclassified!public! !
!PilotRecord categoriesFor: #uniqueID:!*-unclassified!public! !

!PilotRecord class methodsFor!

dmAllRecAttrs
	^16rF0!

dmRecAttrBusy
	^16r20!

dmRecAttrCategoryMask
	^16r0F!

dmRecAttrDelete
	^16r80!

dmRecAttrDirty
	^16r40!

dmRecAttrSecret
	^16r10! !

!PilotRecord class categoriesFor: #dmAllRecAttrs!*-unclassified!public! !
!PilotRecord class categoriesFor: #dmRecAttrBusy!*-unclassified!public! !
!PilotRecord class categoriesFor: #dmRecAttrCategoryMask!*-unclassified!public! !
!PilotRecord class categoriesFor: #dmRecAttrDelete!*-unclassified!public! !
!PilotRecord class categoriesFor: #dmRecAttrDirty!*-unclassified!public! !
!PilotRecord class categoriesFor: #dmRecAttrSecret!*-unclassified!public! !

!Time class methodsFor!

dateAndTimeFromSeconds: anInteger 
	"Answer an Array whose first element is the Date and whose
	second element is the Time."

	| date time |
	date := Date fromSeconds: anInteger.
	time := self fromSeconds: (anInteger - date asSeconds).
	^Array with: date with: time! !

!Time class categoriesFor: #dateAndTimeFromSeconds:!accessing!public! !

!ByteArray methodsFor!

dwordAtOffset: anInteger bigEndian: aBoolean
	"Answer the unsigned 4 byte integer at offset (i.e. zero relative) 
	anInteger IN the receiver.
	If bigEndian is true, then self is read frontToBack, otherwise the primitive is called"

	| answer |
	aBoolean ifFalse: [ ^self dwordAtOffset: anInteger ].
	answer := 0.
	0 to: 3 by: 1 do: [:i |
		answer := (answer bitShift: 8) + (self byteAtOffset: anInteger + i)].
	^answer
! !

!ByteArray categoriesFor: #dwordAtOffset:bigEndian:!accessing!primitives!public! !

!ByteArray methodsFor!

dwordAtOffset: anInteger put: anObject bigEndian: aBoolean
	"Store an unsigned 4 byte value at byte offset anInteger 
	within the receiver.
	if the boolean is true, the bytes are reversed."

	| tempArray |
	aBoolean ifFalse: [^self wordAtOffset: anInteger put: anObject ].
	tempArray := ByteArray new: 4.
	tempArray dwordAtOffset: 0 put: anObject.
	tempArray := tempArray reverse.
	1 to: 4 do: [ :index | self basicAt: (anInteger + index) put: (tempArray at: index) ].
	^tempArray
! !

!ByteArray categoriesFor: #dwordAtOffset:put:bigEndian:!accessing!primitives!public! !

!ByteArray methodsFor!

wordAtOffset: anInteger bigEndian: aBoolean
	"Answer the unsigned 2 byte integer at offset (i.e. zero relative) anInteger in the receiver. 
	On iX86 the high and low order bytes are reversed; i.e. the bytes are ordered least 
	significant first. If aBoolean is true, biggest number first. If aBoolean is false, the standard primitive is run. if aBoolean is true, the ByteArray is read frontToBack"

	| answer |
	answer := 0.
	aBoolean ifFalse: [^self wordAtOffset: anInteger].
	0 to: 1 by: 1 do: [:i |
		answer := (answer bitShift: 8) + (self byteAtOffset: anInteger + i)].
	^answer
! !

!ByteArray categoriesFor: #wordAtOffset:bigEndian:!accessing!primitives!public! !

!ByteArray methodsFor!

wordAtOffset: anInteger put: anObject bigEndian: aBoolean
	"Store an unsigned 16-bit value at byte offset anInteger within the receiver.
	If anObject is not representable as a 16-bit unsigned (Small)Integer, then 
	raise a 'cannot hold' error.
	if aBoolean is true, reverse the array"

	| tempArray |
	aBoolean ifFalse: [^self wordAtOffset: anInteger put: anObject ].
	tempArray := ByteArray new: 2.
	tempArray wordAtOffset: 0 put: anObject.
	tempArray := tempArray reverse.
	1 to: 2 do: [ :index | self basicAt: (anInteger + index) put: (tempArray at: index) ].
	^tempArray! !

!ByteArray categoriesFor: #wordAtOffset:put:bigEndian:!accessing!primitives!public! !

 